﻿using System;
using System.Collections.Generic;
using System.Data.SqlClient;
using System.Data;
using System.Text;
using BusinessEntities;

namespace EntityServices
{
  public class CustomerProfile
  {

      string _dbConnect = @"Data Source=.\SQLEXPRESS;AttachDbFilename=C:\Kod VS2010\R22\ASP.NET Web Service Example\ASP.NET Web Service Example\EntityServices\northwnd.mdf;Integrated Security=True;User Instance=True";

    public DataSet GetActiveCustomers()
    {
      StringBuilder sql = new StringBuilder("SELECT CustomerID, CompanyName, ");
      sql.Append("ContactName, ContactTitle, Address, City, Region, ");
      sql.Append("PostalCode, Country, Phone, Fax ");
      sql.Append("FROM Customers");

      using (SqlConnection cnn = new SqlConnection(_dbConnect))
      {
        SqlCommand cmd = new SqlCommand(sql.ToString(), cnn);
        cmd.CommandType = CommandType.Text;

        cnn.Open();
        SqlDataAdapter adp = new SqlDataAdapter(cmd);
        DataSet ds = new DataSet();
        adp.Fill(ds);
        cnn.Close();
        return ds;
      }
    }



    public Customer GetCustomer(string customerId)
    {

      StringBuilder sql = new StringBuilder("SELECT CustomerID, CompanyName, ");
      sql.Append("ContactName, ContactTitle, Address, City, Region, ");
      sql.Append("PostalCode, Country, Phone, Fax ");
      sql.Append("FROM Customers WHERE CustomerID = @id");

      using (SqlConnection cnn = new SqlConnection(_dbConnect))
      {

        SqlCommand cmd = new SqlCommand(sql.ToString(), cnn);
        cmd.CommandType = CommandType.Text;
        cmd.Parameters.Add(new SqlParameter("id", customerId));

        cnn.Open();
        SqlDataReader dr = cmd.ExecuteReader();
        dr.Read();
        Customer c = new Customer();
        c.Address = dr["Address"].ToString();
        c.City = dr["City"].ToString();
        c.CompanyName = dr["CompanyName"].ToString();
        c.Country = dr["Country"].ToString();
        c.Fax = dr["Fax"].ToString();
        c.Id = dr["CustomerID"].ToString();
        c.Name = dr["ContactName"].ToString();
        c.Phone = dr["Phone"].ToString();
        c.PostalCode = dr["PostalCode"].ToString();
        c.Region = dr["Country"].ToString();
        c.Title = dr["ContactTitle"].ToString();
        dr.Close();

        return c;

      }
    }

    public void SaveCustomer(Customer customer, bool isNew)
    {

      StringBuilder sql = new StringBuilder();
      SqlCommand cmd = new SqlCommand();

      // Sprawdzanie, czy potrzebna jest aktualizacja, czy zapis danych.
      if (isNew)
      {
          // Wstawianie danych.
        sql.Append("INSERT INTO customers (CustomerID, CompanyName, ContactName, ");
        sql.Append("ContactTitle, Address, City, Region, PostalCode, ");
        sql.Append("Country, Phone, Fax) ");
        sql.Append("VALUES(@customerId, @companyName, @contactName, ");
        sql.Append("@contactTitle, @address, @city, @region, @postalCode, ");
        sql.Append("@country, @phone, @fax)");

      }
      else
      {
          // Aktualizacja danych.
        sql.Append("UPDATE customers set companyName=@companyName, ");
        sql.Append("contactName=@contactName, contactTitle=@contactTitle, ");
        sql.Append("Address=@address,  city=@city, region=@region, ");
        sql.Append("postalCode=@postalCode, country=@country, ");
        sql.Append("phone=@phone, fax=@fax ");
        sql.Append("WHERE customerID=@customerId ");
      }

      // Dodatkowe parametry.
      cmd.Parameters.Add(new SqlParameter("@customerId", customer.Id));
      cmd.Parameters.Add(new SqlParameter("@companyName", customer.CompanyName));
      cmd.Parameters.Add(new SqlParameter("@contactName", customer.Name));
      cmd.Parameters.Add(new SqlParameter("@contactTitle", customer.Title));
      cmd.Parameters.Add(new SqlParameter("@address", customer.Address));
      cmd.Parameters.Add(new SqlParameter("@city", customer.City));
      cmd.Parameters.Add(new SqlParameter("@region", customer.Region));
      cmd.Parameters.Add(new SqlParameter("@postalCode", customer.PostalCode));
      cmd.Parameters.Add(new SqlParameter("@country", customer.Country));
      cmd.Parameters.Add(new SqlParameter("@phone", customer.Phone));
      cmd.Parameters.Add(new SqlParameter("@fax", customer.Fax));

      using (SqlConnection cnn = new SqlConnection(_dbConnect))
      {
        cmd.CommandType = CommandType.Text;
        cmd.CommandText = sql.ToString();
        cmd.Connection = cnn;
        cnn.Open();
        cmd.ExecuteNonQuery();
        cnn.Close();
      }
    }

    public void DeleteCustomer(string customerId)
    {

      // Do zrobienia: obsługa kluczy obcych w czasie usuwania danych.

      string sql = "delete from customers where CustomerID = @id";

      using (SqlConnection cnn = new SqlConnection(_dbConnect))
      {
        SqlCommand cmd = new SqlCommand(sql, cnn);
        cmd.CommandType = CommandType.Text;
        cmd.Parameters.Add(new SqlParameter("@id", customerId));
        cnn.Open();
        cmd.ExecuteNonQuery();
        cnn.Close();
      }

    }
  }
}
